/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.codec.ArrayCodec;
import me.jddev0.ep.codec.CodecFix;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;

public class AlloyFurnaceRecipe
implements class_1860<class_9695> {
    private final class_1799 output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final IngredientWithCount[] inputs;
    private final int ticks;

    public AlloyFurnaceRecipe(class_1799 output, OutputItemStackWithPercentages secondaryOutput, IngredientWithCount[] inputs, int ticks) {
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.inputs = inputs;
        this.ticks = ticks;
    }

    public class_1799 getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public IngredientWithCount[] getInputs() {
        return this.inputs;
    }

    public int getTicks() {
        return this.ticks;
    }

    public class_1799[] getMaxOutputCounts() {
        class_1799[] generatedOutputs = new class_1799[]{this.output.method_46651(this.output.method_7947()), this.secondaryOutput.output().method_46651(this.secondaryOutput.percentages().length)};
        return generatedOutputs;
    }

    public class_1799[] generateOutputs(class_5819 randomSource) {
        class_1799[] generatedOutputs = new class_1799[2];
        generatedOutputs[0] = this.output.method_46651(this.output.method_7947());
        int count = 0;
        for (double percentage : this.secondaryOutput.percentages()) {
            if (!(randomSource.method_43058() <= percentage)) continue;
            ++count;
        }
        generatedOutputs[1] = this.secondaryOutput.output().method_46651(count);
        return generatedOutputs;
    }

    public boolean method_8115(class_9695 container, class_1937 level) {
        if (level.field_9236) {
            return false;
        }
        boolean[] usedIndices = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            usedIndices[i] = container.method_59984(i).method_7960();
        }
        int len = Math.min(this.inputs.length, 3);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = this.inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                if (usedIndices[j]) continue;
                class_1799 item = container.method_59984(j);
                if (indexMinCount != -1 && item.method_7947() >= minCount || !input.input().method_8093(item) || item.method_7947() < input.count()) continue;
                indexMinCount = j;
                minCount = item.method_7947();
            }
            if (indexMinCount == -1) {
                return false;
            }
            usedIndices[indexMinCount] = true;
        }
        for (boolean usedIndex : usedIndices) {
            if (usedIndex) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_8116(class_9695 container, class_7225.class_7874 registries) {
        return this.output;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registries) {
        return class_1799.field_8037;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)EPBlocks.ALLOY_FURNACE_ITEM);
    }

    public boolean method_8118() {
        return true;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements class_1865<AlloyFurnaceRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = EPAPI.id("alloy_furnace");
        private final MapCodec<AlloyFurnaceRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)OutputItemStackWithPercentages.CODEC_NONEMPTY.optionalFieldOf("secondaryOutput").forGetter(recipe -> Optional.ofNullable(recipe.secondaryOutput.isEmpty() ? null : recipe.secondaryOutput)), (App)new ArrayCodec<IngredientWithCount>(IngredientWithCount.CODEC_NONEMPTY, IngredientWithCount[]::new).fieldOf("inputs").forGetter(recipe -> recipe.inputs), (App)class_5699.field_33442.fieldOf("ticks").forGetter(recipe -> recipe.ticks)).apply((Applicative)instance, (output, secondaryOutput, inputs, ticks) -> new AlloyFurnaceRecipe((class_1799)output, secondaryOutput.orElse(OutputItemStackWithPercentages.EMPTY), (IngredientWithCount[])inputs, (int)ticks)));
        private final class_9139<class_9129, AlloyFurnaceRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<AlloyFurnaceRecipe> method_53736() {
            return this.CODEC;
        }

        public class_9139<class_9129, AlloyFurnaceRecipe> method_56104() {
            return this.PACKET_CODEC;
        }

        private static AlloyFurnaceRecipe read(class_9129 buffer) {
            int len = buffer.readInt();
            IngredientWithCount[] inputs = new IngredientWithCount[len];
            for (int i = 0; i < len; ++i) {
                inputs[i] = (IngredientWithCount)IngredientWithCount.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            }
            int ticks = buffer.readInt();
            class_1799 output = (class_1799)class_1799.field_49268.decode((Object)buffer);
            OutputItemStackWithPercentages secondaryOutput = (OutputItemStackWithPercentages)OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new AlloyFurnaceRecipe(output, secondaryOutput, inputs, ticks);
        }

        private static void write(class_9129 buffer, AlloyFurnaceRecipe recipe) {
            buffer.method_53002(recipe.inputs.length);
            for (int i = 0; i < recipe.inputs.length; ++i) {
                IngredientWithCount.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.inputs[i]);
            }
            buffer.method_53002(recipe.ticks);
            class_1799.field_49268.encode((Object)buffer, (Object)recipe.output);
            OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.secondaryOutput);
        }
    }

    public static final class Type
    implements class_3956<AlloyFurnaceRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "alloy_furnace";

        private Type() {
        }
    }
}

